/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.util;

import com.hidoni.customizableelytra.items.CustomizableElytraItem;
import com.hidoni.customizableelytra.util.ColorUtil;
import com.hidoni.customizableelytra.util.CustomizationHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;

public class BannerCustomizationHandler
extends CustomizationHandler {
    private final List<Pair<BannerPattern, DyeColor>> patterns;

    public BannerCustomizationHandler(ItemStack itemIn) {
        this(itemIn.m_41784_());
    }

    public BannerCustomizationHandler(CompoundTag tagIn) {
        super(tagIn.m_128471_("HideCapePattern"), tagIn.m_128451_("WingLightLevel"));
        CompoundTag blockEntityTag = tagIn.m_128469_("BlockEntityTag");
        DyeColor baseColor = DyeColor.m_41053_((int)blockEntityTag.m_128451_("Base"));
        ListTag patternsList = blockEntityTag.m_128437_("Patterns", 10).m_6426_();
        this.patterns = BannerBlockEntity.m_58484_((DyeColor)baseColor, (ListTag)patternsList);
    }

    @Override
    public int getColor(int index) {
        return ColorUtil.convertDyeColorToInt((DyeColor)this.patterns.get(0).getSecond());
    }

    @Override
    public <T extends LivingEntity, M extends AgeableListModel<T>> void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, M renderModel, ResourceLocation textureLocation, boolean hasGlint) {
        renderModel.m_6973_(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        VertexConsumer ivertexbuilder = ItemRenderer.m_115222_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110482_((ResourceLocation)textureLocation), (boolean)false, (boolean)hasGlint);
        renderModel.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        float[] baseColor = ((DyeColor)this.patterns.get(0).getSecond()).m_41068_();
        renderModel.m_7695_(matrixStackIn, ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110473_((ResourceLocation)textureLocation), (boolean)false, (boolean)false), packedLightIn, OverlayTexture.f_118083_, baseColor[0], baseColor[1], baseColor[2], 1.0f);
        for (int i = 1; i < 17 && i < this.patterns.size(); ++i) {
            Pair<BannerPattern, DyeColor> pair = this.patterns.get(i);
            float[] afloat = ((DyeColor)pair.getSecond()).m_41068_();
            Material rendermaterial = new Material(TextureAtlas.f_118259_, CustomizableElytraItem.getTextureLocation((BannerPattern)pair.getFirst()));
            if (rendermaterial.m_119204_().m_118413_() == MissingTextureAtlasSprite.m_118071_()) continue;
            renderModel.m_7695_(matrixStackIn, rendermaterial.m_119194_(bufferIn, RenderType::m_110473_), packedLightIn, OverlayTexture.f_118083_, afloat[0], afloat[1], afloat[2], 1.0f);
        }
    }
}

